/**
 * \file            dm_field_debug.h
 * \brief           This file contains field_debug related definitions
 *                  It has been simplified to simply print to the console
 *                  Ported from the AIP/DVPHD
 *
 * \author          Adolfo Velasco
 *                  Yun Mao
 *
 * \date            06/16/08
 * \warning
 * \note
 * \review
 **/

#ifndef _DM_FIELD_DEBUG_H
#define _DM_FIELD_DEBUG_H

#include "dm_nutypedefs.h"
#include "dm_console.h"        //Needed for DmConsolePrintf

#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************
*   Defines and Struct
**********************************************************************/

//Field debug indices
enum
{
    DM_FIELD_HDMI_RX_DEBUG_IDX = 1,                     //1
    DM_FIELD_HDMI_TX_DEBUG_IDX,                         //2
    DM_FIELD_ANALOG_RX_DEBUG_IDX,                       //3
    DM_FIELD_HDCP_DEV_SIZE_TEST_DEBUG_IDX,              //4
    DM_FIELD_HDCP_CP_VERIFICATION_IDX,                  //5
    DM_FIELD_DEBUG_EDID_IDX,                            //6
    DM_FIELD_CRESNET_RX_IDX,                            //7
    DM_FIELD_CRESNET_TX_IDX,                            //8
    DM_FIELD_HDMI_RX_AUDIO_DEBUG_IDX,                   //9
    DM_FIELD_DSP_DEBUG_IDX,                             //10
    DM_FIELD_HDMI_FIBER_DEBUG_IDX,                      //11
    DM_FIELD_USB_DEBUG_IDX,                             //12
    DM_FIELD_HDCP_RX_DEBUG_IDX,                         //13
    DM_FIELD_HDCP_TX_DEBUG_IDX,                         //14
    DM_FIELD_HDMI_TX_AUDIO_DEBUG_IDX,                   //15
    DM_FIELD_STREAM_DEBUG_IDX,                          //16
    DM_FIELD_DM_RX_DEBUG_IDX,                           //17
    DM_FIELD_DM_TX_DEBUG_IDX,                           //18
    DM_FIELD_DM_SERIAL_PORT_DEBUG_IDX,                  //19
    DM_FIELD_DM_MASTER_DEBUG_IDX,                       //20
    DM_FIELD_DM_SLAVE_DEBUG_IDX,                        //21
    DM_FIELD_ETHERNET_DEBUG_IDX,                        //22
    DM_FIELD_DMNET_CEC_DEBUG_IDX,                       //23
    DM_FIELD_SDI_RX_DEBUG_IDX,                          //24
    DM_FIELD_SCALER_DEBUG_IDX,                          //25
    DM_FIELD_ANALOG_TX_DEBUG_IDX,                       //26
    DM_FIELD_OW_RX_DEBUG_IDX,                           //27
    DM_FIELD_OW_TX_DEBUG_IDX,                           //28
    DM_FIELD_VS_RX_DEBUG_IDX,                           //29
    DM_FIELD_VS_TX_DEBUG_IDX,                           //30
    DM_FIELD_OW_POLL_DEBUG_IDX,                         //31
    DM_FIELD_OW_EDID_DEBUG_IDX,                         //32
    DM_FIELD_OW_HDCP_DEBUG_IDX,                         //33
    DM_FIELD_OVERLAY_HANDLER_IDX,                       //34
    DM_FIELD_LVDS_RX_IDX,                               //35
    DM_FIELD_CEC_IDX,                                   //36
    DM_FIELD_AUDIO_DAC_IDX,                             //37
    DM_FIELD_FPGA_IDX,                                  //38
    DM_FIELD_ENCAPSULATION_IDX,                         //39
    DM_FIELD_SWITCHER_IDX,                              //40
    DM_FIELD_DP_RX_IDX,                                 //41
    DM_FIELD_TOUCH_DEBUG_IDX,                           //42
    DM_FIELD_TOUCH_CALIBRATE_DEBUG_IDX,                 //43
    DM_FIELD_IR_TX_IDX,                                 //44
    DM_FIELD_DM_CONTROLLER_IDX,                         //45
    DM_FIELD_SYSTEM_STATS_IDX,                          //46
    DM_FIELD_DEBUG_EXT_TOOL_EDID_IDX,                   //47
    DM_FIELD_USB_ICRON_DEBUG_IDX,                       //48
    DM_FIELD_VIDEO_MESSAGE_HANDLER_DEBUG_IDX,           //49
    DM_FIELD_FRONT_PANEL_DEBUG_IDX,                     //50
    DM_FIELD_CNET_MASTER_DEBUG_IDX,                     //51
	DM_FIELD_LCD_MANAGER_DEBUG_IDX,						//52
	DM_FIELD_INTERAPP_DEBUG_IDX,						//53
    DM_FIELD_TESTGEN_DEBUG_IDX,                         //54
    DM_FIELD_AMP_AUDIO_DEBUG_IDX,                       //55
    DM_FIELD_CHANNELMGR_DEBUG_IDX,                      //56
    DM_FIELD_4K_AVM_DEBUG_IDX ,                         //57
    DM_FIELD_4K_AVM_CNET_DEBUG_IDX,                     //58
    DM_FIELD_I2C_DEBUG_IDX,                             //59
    MAX_DM_FIELD_DEBUG_NUM
};

//Verification macro
#define IsValidDmFieldIndex(a)            ( a > 0 && a < MAX_DM_FIELD_DEBUG_NUM )

//Field debug UINT32 array size
#define DM_FIELD_DEBUG_ARRAY_SIZE         ( ((MAX_DM_FIELD_DEBUG_NUM-1)/32)+1 )

/**********************************************************************
*   External Variables
**********************************************************************/
extern UINT32 g_lDmFieldDebugState[DM_FIELD_DEBUG_ARRAY_SIZE];

//Field debug macros
#define IsDmFieldDebugIndexActive(a)      ( g_lDmFieldDebugState[((a-1)/32)] & (1<<((a-1)%32)) )
#define EnableDmFieldDebugIndex(a)        ( g_lDmFieldDebugState[((a-1)/32)] |= (1<<((a-1)%32)) )
#define DisableDmFieldDebugIndex(a)       ( g_lDmFieldDebugState[((a-1)/32)] &= ~(1<<((a-1)%32)) )

/**********************************************************************
*   External Functions
**********************************************************************/
INT32 DmFieldDebugCmd(UINT32 argc, char *cmd);

extern void DmDebugPrintf(char* format,...);

#ifdef __cplusplus
}
#endif

#endif  //_DM_FIELD_DEBUG_H
